/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8281;

import ibm.nways.cfgtool.CfgToolContext;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.NavigationBrowser;
import ibm.nways.jdm.NavigationBrowserEventListener;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationItem;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.browser.Browser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.common.Timeout;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmContext;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.jdm8281.DeviceView.Builder;
import ibm.nways.jdm8281.DeviceView.ChassisLike;
import ibm.nways.jdm8281.eui.ConfigurationGroup;
import ibm.nways.jdm8281.eui.FaultGroup;
import ibm.nways.ras.RAS;
import ibm.nways.web.WebContext;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ResourceBundle;

public class Jdm8281
extends JdmBrowser {
    private NavigationFolder rootFolder;
    private NavigationBrowser tree;
    private static final int RASID = 19;
    private static final int RASSUB = 12;
    private ResourceBundle resBundle = ResourceBundle.getBundle("ibm.nways.jdm8281.Resources");
    private GenModel deviceModel;
    private NavFieldOverride jdm8281Overrides;
    static final Object[][] jdm8281FieldOverrides = new Object[][]{{"ibm.nways.lane.model.Lec.Panel.LecConfigLanType.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecConfigMaxDataFrameSize.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecMaxUnknownFrameTime.access", "not-supported"}, {"ibm.nways.lane.model.Lec.Panel.LecAgingTime.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecForwardDelayTime.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecMulticastSendType.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecMulticastSendAvgRate.access", "not-supported"}, {"ibm.nways.lane.model.Lec.Panel.LecMulticastSendPeakRate.access", "not-supported"}};
    public static final String CFG_8281_DEFAULT = "8281_DEFAULT";
    public static final String NEW_CFG_TOOL_NAME = "MACK_WIN.EXE";
    public static final String CFG_8281 = "8281";
    public static final boolean NOTGOOD = false;
    public static final boolean GOOD = true;
    private static boolean boxStatus;

    public String getModelTypeName() {
        return "ibm.nways.jdm8281.model.Jdm8281";
    }

    public GraphicPanel getDeviceGraphicPanel() {
        ChassisLike chassisLike = Builder.getInstance().buildChassis(this);
        chassisLike.draw();
        return chassisLike.getGraphicPanel();
    }

    protected NavigationPoint getNavTreeRoot() {
        this.deviceModel = (GenModel)this.getModel();
        this.rootFolder = new NavigationFolder(this.resBundle.getString("jmaTitle"));
        NavigationContext navigationContext = this.rootFolder.getNavContext();
        this.jdm8281Overrides = new NavFieldOverride(navigationContext, jdm8281FieldOverrides);
        Serializable serializable = null;
        try {
            GenModel genModel = (GenModel)this.deviceModel.getComponent("System");
            ModelInfo modelInfo = genModel.getInfo("Panel");
            serializable = modelInfo.get("Panel.SysObjectID");
            if (RAS.isEnabled(19, 12)) {
                RAS.trace(19, 12, (Object)this, "getNavTreeRoot", "Returned Sysoid = " + serializable);
            }
            if (serializable instanceof Timeout || serializable instanceof NotSupported) {
                this.setBoxStatus(false);
            } else if (serializable instanceof OID) {
                if (RAS.isEnabled(19, 12)) {
                    RAS.trace(19, 12, (Object)this, "getNavTreeRoot", "Sysoid = " + serializable);
                }
                this.setBoxStatus(true);
                String string = serializable.toString();
                if (string.equals("1.3.6.1.4.1.2.6.28")) {
                    this.rootFolder.setLabel(this.resBundle.getString("jmaTitleS"));
                } else if (string.equals("1.3.6.1.4.1.2.6.28.9.1")) {
                    this.rootFolder.setLabel(this.resBundle.getString("jmaTitleI"));
                } else {
                    this.setBoxStatus(false);
                }
            }
        }
        catch (RemoteException remoteException) {
            this.setBoxStatus(false);
            RAS.logException(19, 12, (Object)this, "getNavTreeRoot", (Exception)remoteException);
        }
        return this.rootFolder;
    }

    protected void getRestOfNavTree() {
        this.displayMsg(this.resBundle.getString("startTree"));
        NavigationFolder cfr_ignored_0 = (NavigationFolder)this.getNavigationTree();
        this.tree = this.getNavigationBrowser();
        NavigationContext navigationContext = this.rootFolder.getNavContext();
        navigationContext.put((Object)"TREE", (Object)this.tree);
        if (RAS.isEnabled(19, 12)) {
            RAS.trace(19, 12, (Object)this, "getNavTreeRoot", "Box Status = " + this.getBoxStatus());
        }
        this.buildConfigFolder(this.rootFolder);
        if (this.getBoxStatus()) {
            this.buildFaultFolder(this.rootFolder);
        }
        this.buildToolsFolder(this.rootFolder);
        this.displayMsg(this.resBundle.getString("endTree"));
    }

    public void buildConfigFolder(NavigationFolder navigationFolder) {
        try {
            GenModel genModel = (GenModel)this.deviceModel.getComponent("Configuration");
            ConfigurationGroup configurationGroup = new ConfigurationGroup((JdmBrowser)this, genModel);
            configurationGroup.setIsInitiallyExpanded(false);
            this.tree.addEventListener((NavigationBrowserEventListener)configurationGroup);
            this.rootFolder.add((NavigationPoint)configurationGroup);
            return;
        }
        catch (RemoteException remoteException) {
            RAS.logException(19, 12, (Object)this, "buildConfigFolder", (Exception)remoteException);
            return;
        }
    }

    public void buildFaultFolder(NavigationFolder navigationFolder) {
        try {
            GenModel genModel = (GenModel)this.deviceModel.getComponent("Fault");
            FaultGroup faultGroup = new FaultGroup((JdmBrowser)this, genModel);
            faultGroup.setIsInitiallyExpanded(false);
            this.tree.addEventListener((NavigationBrowserEventListener)faultGroup);
            this.rootFolder.add((NavigationPoint)faultGroup);
            return;
        }
        catch (RemoteException remoteException) {
            RAS.logException(19, 12, (Object)this, "buildFaultFolder", (Exception)remoteException);
            return;
        }
    }

    public void buildToolsFolder(NavigationFolder navigationFolder) {
        NavigationContext navigationContext;
        ResourceBundle resourceBundle;
        Object object;
        SnmpContextModel snmpContextModel;
        Object object2;
        String string = null;
        NavigationFolder navigationFolder2 = new NavigationFolder(this.resBundle.getString("tools"), new NavigationDestination("ibm.nways.jdm.NilDestination", null));
        CfgToolContext cfgToolContext = null;
        try {
            object2 = this.getNavigationBrowser();
            snmpContextModel = (SnmpContextModel)this.deviceModel.getComponent("_ContextInfo");
            object = new Browser(this.resBundle.getString("mibBrowser"), (JdmBrowser)this, snmpContextModel);
            object2.addEventListener((NavigationBrowserEventListener)object);
            navigationFolder2.add((NavigationPoint)object.getRootFolder());
        }
        catch (RemoteException remoteException) {
            RAS.logException(19, 12, (Object)this, "buildToolsFolder", (Exception)remoteException);
        }
        try {
            snmpContextModel = (SnmpContextModel)this.deviceModel.getComponent("_ContextInfo");
            object2 = snmpContextModel.getConfig();
            string = ((ModelInfo)object2).get("Config.Address").toString();
            object = new WebContext(string);
            resourceBundle = ResourceBundle.getBundle("ibm.nways.web.Resources");
            object.support_and_device();
            NavigationItem navigationItem = new NavigationItem(resourceBundle.getString("weblaunch"), new NavigationDestination("ibm.nways.web.WebBrowserPanel", null), "WebBrowser");
            navigationContext = navigationItem.getNavContext();
            navigationContext.put((Object)"webContext", object);
            navigationFolder2.add((NavigationPoint)navigationItem);
        }
        catch (RemoteException remoteException) {
            RAS.logException(19, 12, (Object)this, "buildToolsFolder", (Exception)remoteException);
        }
        try {
            object2 = System.getProperty("os.name");
            if (this.getIsApplication() && ((String)object2).equals("Windows NT")) {
                if (this.getBoxStatus()) {
                    cfgToolContext = CfgToolContext.autoDetect((String)CFG_8281, (int)2, (int)1, (int)0);
                }
                if (cfgToolContext == null) {
                    if (RAS.isEnabled(19, 12)) {
                        RAS.trace(19, 12, (Object)this, "getNavTreeRoot", "Use old API for config tool");
                    }
                    cfgToolContext = new CfgToolContext(CFG_8281_DEFAULT);
                    cfgToolContext.setCfgExeName(NEW_CFG_TOOL_NAME);
                }
                object = ResourceBundle.getBundle("ibm.nways.cfgtool.CfgToolGroupResources");
                resourceBundle = new NavigationItem(((ResourceBundle)object).getString("cfgtoolPanelTitle"), new NavigationDestination("ibm.nways.cfgtool.CfgToolPanel", null), "CfgTool");
                navigationContext = resourceBundle.getNavContext();
                navigationContext.put((Object)"cfgtoolContext", (Object)cfgToolContext);
                navigationFolder2.add((NavigationPoint)resourceBundle);
            }
            if (this.getIsApplication() && string != null) {
                object = new AnalyzerJdmContext(string, this.getServerPortNumber());
                resourceBundle = new NavigationItem(AnalyzerJdmPanel.getTitle(), new NavigationDestination("ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel", null), "Analyzer");
                navigationContext = resourceBundle.getNavContext();
                navigationContext.put((Object)"analyzerJdmContext", object);
                navigationFolder2.add((NavigationPoint)resourceBundle);
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 12, (Object)this, "buildToolsFolder", exception);
        }
        navigationFolder.add((NavigationPoint)navigationFolder2);
    }

    public void setBoxStatus(boolean bl) {
        boxStatus = bl;
    }

    public boolean getBoxStatus() {
        return boxStatus;
    }
}

